<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Inspeccion extends Model 
{

    protected $table = 'inspeccion';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function inspectores()
    {
        return $this->hasMany('App\Moron\Models\InspeccionInspector', 'inspector_id');
    }

    public function derivaciones()
    {
        return $this->hasMany('App\Moron\Models\Derivacion', 'inspeccion_id');
    }

}